/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.impl;

import com.quantumdata.sct.dao.exception.CreateException;
import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.exception.ReadException;
import com.quantumdata.sct.dao.impl.AbstractXMLStorageDAO;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.jaxb.CapabilitySection;
import com.quantumdata.sct.dao.jaxb.CapabilitySections;
import com.quantumdata.sct.dao.jaxb.CapabilitySectionsType;
import com.quantumdata.sct.dao.jaxb.impl.CapabilitySectionImpl;
import com.quantumdata.sct.dao.jaxb.impl.CapabilitySectionsImpl;
import com.quantumdata.sct.dao.vo.CapabilitySectionVO;
import com.quantumdata.sct.util.keygen.KeyGenerator;
import com.quantumdata.sct.util.keygen.RandTSKeyGenerator;
import java.util.Iterator;

public final class CapabilitySectionDAO
extends AbstractXMLStorageDAO {
    private KeyGenerator keygen = RandTSKeyGenerator.instance();

    private CapabilitySectionsType.CapabilitySection get(Integer n) throws ReadException {
        if (n == null) {
            throw new ReadException("Invalid index");
        }
        int n2 = ((CapabilitySections)this.daoObject).getSections().size();
        if (n >= n2) {
            throw new ReadException("Index out of bounds error");
        }
        CapabilitySectionsType.CapabilitySection capabilitySection = (CapabilitySectionsType.CapabilitySection)((CapabilitySections)this.daoObject).getSections().get(n);
        return capabilitySection;
    }

    public void readCallback() throws DAOException {
        try {
            CapabilitySections capabilitySections = (CapabilitySections)this.daoObject;
            Iterator iterator = capabilitySections.getSections().iterator();
            int n = 0;
            this.daoCollection.clear();
            while (iterator.hasNext()) {
                CapabilitySection capabilitySection = (CapabilitySection)iterator.next();
                this.daoCollection.put(capabilitySection.getId(), new Integer(n));
                ++n;
            }
            this.initialize = true;
        }
        catch (Exception exception) {
            this.initialize = false;
            throw new DAOException("Unable to load", null, exception);
        }
    }

    public final Object getUniqueKey() {
        return this.keygen.generateUniqueKey();
    }

    public final IPersistable getValueObjectForKey(Object object) throws CreateException {
        try {
            Integer n = (Integer)this.daoCollection.get(object);
            CapabilitySectionsType.CapabilitySection capabilitySection = this.get(n);
            return this.createPersistable(capabilitySection);
        }
        catch (Exception exception) {
            throw new CreateException("Unable to create with key =" + object, null, exception);
        }
    }

    public final IPersistable[] findByAll() throws Exception {
        int n = ((CapabilitySectionsImpl)this.daoObject).getSections().size();
        IPersistable[] iPersistableArray = new IPersistable[n];
        for (int i = 0; i < n; ++i) {
            CapabilitySectionsType.CapabilitySection capabilitySection = (CapabilitySectionsType.CapabilitySection)((CapabilitySectionsImpl)this.daoObject).getSections().get(i);
            iPersistableArray[i] = this.createPersistable(capabilitySection);
        }
        return iPersistableArray;
    }

    public final Object getUniqueKey(Object object) {
        Object object2 = null;
        if (object instanceof CapabilitySectionsType.CapabilitySection) {
            CapabilitySectionsType.CapabilitySection capabilitySection = (CapabilitySectionsType.CapabilitySection)object;
            object2 = capabilitySection.getId();
        } else {
            object2 = this.getUniqueKey();
        }
        return object2;
    }

    private IPersistable createPersistable(Object object) throws Exception {
        CapabilitySectionVO capabilitySectionVO = new CapabilitySectionVO();
        if (object instanceof CapabilitySectionsType.CapabilitySection) {
            this.copyFrom((CapabilitySectionsType.CapabilitySection)object, capabilitySectionVO);
        }
        return capabilitySectionVO;
    }

    private void copyFrom(CapabilitySectionsType.CapabilitySection capabilitySection, CapabilitySectionVO capabilitySectionVO) throws Exception {
        capabilitySectionVO.setId(capabilitySection.getId());
        capabilitySectionVO.setName(capabilitySection.getName());
        capabilitySectionVO.setDescription(capabilitySection.getDescription());
        for (CapabilitySection.CapabilityId capabilityId : capabilitySection.getCapabilities()) {
            capabilitySectionVO.add(capabilityId.getValue());
        }
    }

    private void copyTo(CapabilitySectionsType.CapabilitySection capabilitySection, CapabilitySectionVO capabilitySectionVO) throws Exception {
        capabilitySection.setId((String)capabilitySectionVO.getId());
        capabilitySection.setName(capabilitySectionVO.getName());
        capabilitySection.setDescription(capabilitySectionVO.getDescription());
        Iterator iterator = capabilitySectionVO.iterator();
        while (iterator.hasNext()) {
            CapabilitySectionImpl.CapabilityIdImpl capabilityIdImpl = (CapabilitySectionImpl.CapabilityIdImpl)this.factory.createCapabilitySectionCapabilityId((String)iterator.next());
            capabilitySection.getCapabilities().add(capabilityIdImpl);
        }
    }

    protected final void updateObject(IPersistable iPersistable) throws Exception {
        if (iPersistable instanceof CapabilitySectionVO) {
            CapabilitySectionVO capabilitySectionVO = (CapabilitySectionVO)iPersistable;
            Integer n = (Integer)this.daoCollection.get(capabilitySectionVO.getId());
            CapabilitySectionsType.CapabilitySection capabilitySection = this.get(n);
            this.copyTo(capabilitySection, capabilitySectionVO);
        }
    }

    protected final IPersistable findByPrimaryKey(String string) {
        CapabilitySectionVO capabilitySectionVO = null;
        try {
            if (this.daoCollection.containsKey(string)) {
                Integer n = (Integer)this.daoCollection.get(string);
                CapabilitySectionsType.CapabilitySection capabilitySection = this.get(n);
                capabilitySectionVO = new CapabilitySectionVO();
                this.copyFrom(capabilitySection, capabilitySectionVO);
            }
        }
        catch (Exception exception) {
            this.log(exception.getMessage());
            capabilitySectionVO = null;
        }
        return capabilitySectionVO;
    }

    protected final void removeByPrimaryKey(Object object) throws DAOException {
        try {
            ((CapabilitySections)this.daoObject).getSections().remove(object);
            this.flush();
            this.readCallback();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DAOException(throwable.getMessage());
        }
    }

    public final void add(IPersistable iPersistable) throws CreateException {
        this.add(iPersistable, 0);
    }

    public final void add(IPersistable iPersistable, int n) throws CreateException {
        try {
            if (iPersistable instanceof CapabilitySectionVO) {
                CapabilitySectionsType.CapabilitySection capabilitySection = this.factory.createCapabilitySectionsTypeCapabilitySection();
                this.copyTo(capabilitySection, (CapabilitySectionVO)iPersistable);
                if (n > 0) {
                    ((CapabilitySections)this.daoObject).getSections().add(n, iPersistable);
                } else {
                    ((CapabilitySections)this.daoObject).getSections().add(iPersistable);
                }
            } else {
                throw new Exception("Invalid Value Object being passed");
            }
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            throw new CreateException("Unable to add element = " + iPersistable.getId(), null, exception);
        }
    }
}

